/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.mixin.compat.origins;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.item.ModItemTags;
import com.github.mim1q.convenientdecor.item.RaincoatItem;
import com.github.mim1q.convenientdecor.item.UmbrellaItem;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"io.github.apace100.apoli.power.factory.condition.ConditionFactory"})
public class ApoliConditionFactoryMixin {
    @Mutable
    @Shadow
    @Final
    private BiFunction condition;
    @Unique
    private BiFunction oldCondition;
    @Unique
    private static final Set<ResourceLocation> CONDITIONS_NEGATED_BY_UMBRELLA = Set.of(ApoliConditionFactoryMixin.apoliId("exposed_to_sky"), ApoliConditionFactoryMixin.apoliId("exposed_to_sun"), ApoliConditionFactoryMixin.apoliId("in_rain"));
    @Unique
    private static final Set<ResourceLocation> CONDITIONS_NEGATED_BY_RAIN_CLOTHES = Set.of(ApoliConditionFactoryMixin.apoliId("in_rain"));

    @Unique
    private static ResourceLocation apoliId(String name) {
        return new ResourceLocation("apoli", name);
    }

    @Inject(method={"<init>(Lnet/minecraft/util/Identifier;Lio/github/apace100/calio/data/SerializableData;Ljava/util/function/BiFunction;)V"}, at={@At(value="TAIL")})
    private void init(ResourceLocation identifier, @Coerce Object data, BiFunction condition, CallbackInfo ci) {
        this.oldCondition = condition;
        if (ConvenientDecor.CONFIG.features.umbrellaOriginsIntegration && CONDITIONS_NEGATED_BY_UMBRELLA.contains(identifier)) {
            ConvenientDecor.LOGGER.info("Patching condition: " + identifier + " to negate with umbrellas");
            this.condition = (a, b) -> (Boolean)this.oldCondition.apply(a, b) != false && !ApoliConditionFactoryMixin.holdingUmbrella((LivingEntity)b);
        }
        if (ConvenientDecor.CONFIG.features.rainclothesOriginsIntegration && CONDITIONS_NEGATED_BY_RAIN_CLOTHES.contains(identifier)) {
            ConvenientDecor.LOGGER.info("Patching condition: " + identifier + " to negate with rain clothes");
            this.condition = (a, b) -> (Boolean)this.oldCondition.apply(a, b) != false && !ApoliConditionFactoryMixin.hasRainClothes((LivingEntity)b);
        }
    }

    @Unique
    private static boolean holdingUmbrella(LivingEntity entity) {
        return ApoliConditionFactoryMixin.holdingUmbrellaInHand(entity, InteractionHand.MAIN_HAND) || ApoliConditionFactoryMixin.holdingUmbrellaInHand(entity, InteractionHand.OFF_HAND);
    }

    @Unique
    private static boolean holdingUmbrellaInHand(LivingEntity entity, InteractionHand hand) {
        ItemStack stack = entity.m_21120_(hand);
        return stack.m_204117_(ModItemTags.UMBRELLAS) && !UmbrellaItem.isFolded(stack);
    }

    @Unique
    private static boolean hasRainClothes(LivingEntity entity) {
        boolean hasRainHat = entity.m_6844_(EquipmentSlot.HEAD).m_204117_(ModItemTags.RAIN_HATS);
        ItemStack rainCoat = entity.m_6844_(EquipmentSlot.CHEST);
        boolean hasRainCoatWithHood = rainCoat.m_204117_(ModItemTags.RAINCOATS) && RaincoatItem.isHooded(rainCoat);
        return hasRainHat || hasRainCoatWithHood;
    }
}

